/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.client.screen.widgets.ContainerWidget;
import dev.toma.gunsrpg.client.screen.widgets.IClickResponder;
import dev.toma.gunsrpg.client.screen.widgets.ITextFormatter;
import dev.toma.gunsrpg.util.ITickable;
import dev.toma.gunsrpg.util.RenderUtils;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class NavigatorWidget<T>
extends ContainerWidget {
    private final T[] values;
    private final NavEntry<T>[] buttons;
    private IClickResponder<T> responder;
    private int selectedIndex;

    public NavigatorWidget(int x, int y, int width, int height, T[] values) {
        super(x, y, width, height);
        this.values = values;
        this.buttons = this.buildEntries(values, x, y, width, height);
        this.setTextFormatter(Object::toString);
    }

    public T getSelectedValue() {
        return this.values[this.selectedIndex];
    }

    public void setTextFormatter(ITextFormatter<T> formatter) {
        Objects.requireNonNull(formatter);
        for (NavEntry<T> entry : this.buttons) {
            entry.updateMessage(formatter);
        }
    }

    public void setClickResponder(IClickResponder<T> responder) {
        this.responder = Objects.requireNonNull(responder);
        for (NavEntry<T> entry : this.buttons) {
            entry.setResponder(this::handleValueClicked);
        }
    }

    public void setColorProvider(Function<T, ITextColorProvider<T>> provider) {
        for (NavEntry<T> entry : this.buttons) {
            entry.setColorProvider(provider.apply(entry.value));
        }
    }

    private void handleValueClicked(T value, int index) {
        this.selectedIndex = index;
        if (this.responder != null) {
            this.responder.onElementClicked(value);
        }
    }

    private NavEntry<T>[] buildEntries(T[] values, int x, int y, int width, int height) {
        int total = values.length;
        int elementWidth = width / total;
        int widthCorrection = width;
        NavEntry[] array = new NavEntry[values.length];
        for (int i = 0; i < values.length - 1; ++i) {
            NavEntry<T> entry = new NavEntry<T>(values[i], idx -> idx == this.selectedIndex, i, x + i * elementWidth, y, elementWidth, height);
            widthCorrection -= elementWidth;
            this.addWidget(entry);
            array[i] = entry;
        }
        int index = total - 1;
        T value = values[index];
        NavEntry<T> last = new NavEntry<T>(value, idx -> idx == this.selectedIndex, index, x + index * elementWidth, y, elementWidth + (widthCorrection -= elementWidth), height);
        this.addWidget(last);
        array[index] = last;
        return array;
    }

    @FunctionalInterface
    public static interface ITextColorProvider<T> {
        default public void tick(T t) {
        }

        public int getColor(T var1, float var2);
    }

    @FunctionalInterface
    private static interface IEntryClickResponder<T> {
        public void onClicked(T var1, int var2);
    }

    private static class NavEntry<V>
    extends Widget
    implements ITickable {
        final int index;
        final V value;
        final Predicate<Integer> isSameIndex;
        IEntryClickResponder<V> responder = (value1, index1) -> {};
        ITextColorProvider<V> colorProvider = (v, partialTicks) -> 0xFFFFFF;

        NavEntry(V value, Predicate<Integer> isSameIndex, int index, int x, int y, int width, int height) {
            super(x, y, width, height, StringTextComponent.field_240750_d_);
            this.value = value;
            this.isSameIndex = isSameIndex;
            this.index = index;
        }

        @Override
        public void tick() {
            this.colorProvider.tick(this.value);
        }

        void updateMessage(ITextFormatter<V> formatter) {
            this.func_238482_a_((ITextComponent)new TranslationTextComponent("nav.entry." + formatter.getFormatted(this.value)));
        }

        void setResponder(IEntryClickResponder<V> responder) {
            this.responder = responder;
        }

        void setColorProvider(ITextColorProvider<V> provider) {
            this.colorProvider = provider;
        }

        public void func_230982_a_(double mouseX, double mouseY) {
            if (this.responder != null) {
                this.responder.onClicked(this.value, this.index);
            }
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            ITextComponent msg = this.func_230458_i_();
            StringTextComponent text = this.field_230692_n_ || this.isSameIndex.test(this.index) ? new StringTextComponent(TextFormatting.BOLD + msg.getString()) : msg;
            FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
            RenderUtils.drawGradient(matrix.func_227866_c_().func_227870_a_(), this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, 0x44000000, 0x7000000);
            RenderUtils.drawCenteredShadowText(matrix, (ITextComponent)text, renderer, this, this.colorProvider.getColor(this.value, partialTicks));
        }
    }
}

